<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
	<?LassoScript
	// Include the library file which contains many of the tags 
	// that are utilized in these examples.
	library((string_replaceregexp: response_path, -find='(.*/).*?/', -replace='\\1') + 'library.lasso');
	// Include the library file which creates the required databases, tables and groups
	library('initialize.lasso');

	?>
	<script src="messageboard.js" type="text/javascript"></script>
	<style type="text/css">
		H2 { text-align: center; }
		TD {vertical-align:top}
				
		body
		{
			background-color: #DFFDDF;
		}
		.group
		{
			background-color: #D8D6AA;
		}
		.avatar
		{
			margin: 0px;
			width: 150px;
			height: 100px;
			font-size: 70%;
			border-right: solid 1px #94ADBE;
		}
		.message_body
		{
			
		}
		.left_bar
		{
			background-color: #D8D6AA;
		}
	</style>
	<title>[Application_appInfo->title ' - ' Application_appInfo->version]</title>
</head>
<body onload="init()">
	<h2>Lasso Message Board</h2>
	<?LassoScript
	/*
			There are 3 pages to this message board. We decide which page we are
		on and what should be shown on that page based on the presence or
		absence of a parameter.
	
		Here are the main pages and their associated parameters:
	
		Forum List - <no parameter>
			This is the default page, simple accessing without any 
			parameters will bring up the forum list.
			
			This page shows the list of available Forums. Each forum is
			listed under it's associated forum group.
		Message List - list=<forum id>
			This page lists all the top level messages in the identified 
			forum.
		Message Detail - detail=<message id>
			This page shows the body of the identified message.
			Only messages which are not in reply to another message can 
			be viewed in this manner.
		
			Each page has its own file which is included and handles the logic
		and display for that page. We will make a page variable that each
		include should set to true, if they were able to hande the request. If
		not set to true, the main forum list will be shown.
	*/
		var('handled' = false);
		if (action_param('list'));
			include('message_list.lasso');
		else(action_param('detail'));
			include('message_detail.lasso');
		/if;
		// if it wasn't handled, do the forum list
		!$handled?
			include('forum_list.lasso');

		// include the footer that is shared by the examples
		include((string_replaceregexp: response_path, -find='(.*/).*?/', -replace='\\1') + 'examples_footer.lasso');
	?>
</body>
</html>
